# FIGURE 6 - PANNEL A
library(ggplot2)
library(seqinr)
library(gggenes)
library(ape)


# Build the dataframe of annotations and positions
genes_df <- data.frame(
  molecule=c(rep("",30)),
  gene=c("DR",rep("hypothetical protein",6),"transposase","transposase","DUF2280 protein","terminase","DUF1073 protein","phage Mu protein F","Acr","Aca","DUF2213 protein","virion structural protein","DUF2184 protein","fibronectin type 3","beta-helix repeats","hypothetical protein","DUF4882 protein","glycosyl hydrolase","glycosyl hydrolase",rep("hypothetical protein",3),"integrase","DR","tRNA-Gly(gcc)"),
  start=c(73071,73220,73582,74291,75098,75646,76413,76812,76910,77505,77965,79464,80743,81635,81864,82550,83768,84242,84730,85789,86926,87434,88252,88416,88969,89628,90336,91178,92105,92319),
  end=c(73093,73573,73773,74608,75376,76104,76757,76937,77458,77987,79455,80798,81555,81823,82496,83749,84238,84733,85728,86775,87315,88207,88419,88826,89559,90092,91064,92104,92127,92384),
  strand=c(rep(T,19),F,rep(T,5),rep(F,3),T,F),
  gene_type= c("Repeats",rep("Unknown",6),rep("Transposase",2),"Unknown","Terminase","Portal","Capsid",rep("Anti-CRISPR",2),"Capsid","Unknown","Capsid",rep("Fiber",2),rep("Unknown",2),rep("Lisozyme",2),rep("Unknown",3),"Integrase", "Repeats","tRNA")
  )
  


# Plot of genes map
ggplot() +
  geom_gene_arrow(data = genes_df, aes(xmin = start, xmax = end, y = molecule, fill=gene_type, forward = strand)) +
  geom_gene_label(data= genes_df, aes(xmin = start, xmax = end, y = molecule, label = gene), stat='identity')+  theme_genes() + labs(fill="Annotations")+
  theme(axis.title.y=element_blank(), axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.ticks.y=element_blank(), legend.position = "top") + scale_fill_manual(values=c("Unknown"="#858585","Capsid"="#D8BFD8","Anti-CRISPR"="#FF3030","Fiber"="#FFF68F","Integrase"="darkolivegreen1","Repeats"="#1874CD","tRNA"="#B2DFEE","Transposase"="lightsteelblue2","Lisozyme"="burlywood1","Portal"="#DDA0DD","Terminase"="#FFC0CB"))+
  labs(title = "Prophage 1012")

